"use client"

import { AuthProvider, useAuth } from "@/lib/auth-context"
import { ChatProvider } from "@/lib/chat-context"
import { AuthPage } from "@/components/auth/auth-page"
import { ChatLayout } from "@/components/chat/chat-layout"

function AppContent() {
  const { user, isLoading } = useAuth()

  if (isLoading) {
    return (
      <div className="min-h-screen flex items-center justify-center bg-background">
        <div className="w-12 h-12 border-4 border-primary border-t-transparent rounded-full animate-spin" />
      </div>
    )
  }

  if (!user) {
    return <AuthPage />
  }

  return (
    <ChatProvider>
      <ChatLayout />
    </ChatProvider>
  )
}

export default function Home() {
  return (
    <AuthProvider>
      <AppContent />
    </AuthProvider>
  )
}
