"use client"

import { ChatSidebar } from "./chat-sidebar"
import { ChatWindow } from "./chat-window"
import { useChat } from "@/lib/chat-context"

export function ChatLayout() {
  const { activeChat } = useChat()

  return (
    <div className="h-screen flex bg-background">
      <div className={`${activeChat ? "hidden md:flex" : "flex"} w-full md:w-auto`}>
        <ChatSidebar />
      </div>
      <div className={`${activeChat ? "flex" : "hidden md:flex"} flex-1`}>
        <ChatWindow />
      </div>
    </div>
  )
}
